<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\Transaction;
use Illuminate\Http\Request;

class UserReportController extends Controller
{
    
    public function transactions()
    {
        $pageTitle = 'Transactions';
        $remarks = Transaction::distinct('remark')->orderBy('remark')->get('remark');
        $transactions = Transaction::where('user_id', auth()->id())
            ->searchable(['trx'])
            ->filter(['trx_type', 'remark'])
            ->orderBy('id', 'desc')
            ->paginate(getPaginate());
        return view('Template::user.transactions', compact('pageTitle', 'transactions', 'remarks'));
    }

    public function purchasedHistory(){
        $user = auth()->user();
        $pageTitle = 'Purchased History';
        $purchasedVideos = $user->purchasedVideos()->with('video')->searchable(['trx', 'video:title'])->paginate(getPaginate());
        return view('Template::user.purchased_history', compact('purchasedVideos','pageTitle'));
    }

}
