<?php

namespace App\Traits;

use App\Constants\Status;
use Illuminate\Support\Facades\File;

trait StorageDriver {
    protected function uploadServer($fileName, $path, $video, $folder) {

        $video->used_ftp = @gs('storage_type');
        $video->save();
        if (in_array($video->used_ftp, [Status::WASABI_SERVER, Status::DIGITAL_OCEAN_SERVER])) {
            $server = activeServer();
            $key    = $folder . '/' . $fileName;
            s3Client()->putObject([
                'Bucket'     => @gs($server)->bucket,
                'Key'        => $key,
                'SourceFile' => $path,
                'ACL'        => 'public-read',
            ]);
        } else {
            $ftp            = ftp();
            $remoteFilePath = $ftp['ftpRoot'] . '/' . $fileName;
            ftp_put($ftp['ftpConn'], $remoteFilePath, $path, FTP_BINARY);
            ftp_close($ftp['ftpConn']);
        }
        File::DELETE($path);
    }

    protected function removeOldFile($uploadVideo, $fileName, $folder) {
        if (in_array($uploadVideo->used_ftp, [Status::WASABI_SERVER, Status::DIGITAL_OCEAN_SERVER])) {
            $server = activeServer($uploadVideo->used_ftp);

            s3Client($server)->deleteObject([
                'Bucket' => @gs($server)->bucket,
                'Key'    => $folder . '/' . $fileName,
            ]);

        } else if ($uploadVideo->used_ftp == Status::FTP_SERVER) {
            $ftp      = ftp();
            $fileList = ftp_nlist($ftp['ftpConn'], $ftp['ftpRoot']);

            if (in_array($ftp['ftpRoot'] . '/' . $fileName, $fileList)) {
                ftp_delete($ftp['ftpConn'], rtrim($ftp['ftpRoot']) . '/' . $fileName);
                ftp_close($ftp['ftpConn']);
            }
        }
    }
}
