@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two custom-data-table">
                            <thead>
                                <tr>
                                    <th>@lang('Title')</th>
                                    <th>@lang('User')</th>
                                    <th>@lang('Visibility')</th>
                                    <th>@lang('Number of Videos')</th>
                                    <th>@lang('Actions')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($playlists as $playlist)
                                    <tr>
                                        <td>{{ __($playlist->title) }}</td>
                                        <td>
                                            {{ __($playlist->user?->fullname) }} <br>
                                            <a href="{{ route('admin.users.detail', $playlist->user_id) }}">
                                                <span>@</span>{{ $playlist->user?->username }}
                                            </a>
                                        </td>
                                        <td>
                                            @php
                                                echo $playlist->statusBadge;
                                            @endphp
                                        </td>
                                        <td>
                                            {{ $playlist->videos->count() }}
                                        </td>
                                        <td>
                                            <div class="button--group">
                                                <button class="btn btn-sm btn-outline--primary editPlaylist" data-playlist="{{ $playlist }}" data-action="{{ route('admin.playlist.update', $playlist->id) }}">
                                                    <i class="las la-pencil-alt"></i>@lang('Edit')
                                                </button>
                                                <a href="{{ route('admin.playlist.videos.list', $playlist->id) }}" class="btn btn-sm btn-outline--info">
                                                    <i class="las la-video"></i>@lang('Video List')
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
            </div><!-- card end -->
        </div>
    </div>


    {{-- NEW MODAL --}}
    <div class="modal custom--modal top-slide" id="playlistModal" tabindex="-1" aria-labelledby="playlistModalLabel"
         aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button type="button" class="close modal-close-btn" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form method="post" class="playlistForm">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="" class="form--label">@lang('Title')</label>
                            <input class="form-control" type="text" name="title" value="{{ old('title') }}" required>
                        </div>
                        <div class="form-group">
                            <label for="" class="form--label">@lang('Description')</label>
                            <textarea name="description" class="form-control" cols="30" rows="10" required>{{ old('description') }}</textarea>
                        </div>
                        <div class="form-group ">
                            <label for="" class="form--label">@lang('Visibility')</label>

                            <div class="check-type-wrapper">
                                <label for="category01" class="check-type check-type-success">
                                    <input class="check-type-input" type="radio" value="0" name="visibility" id="category01" checked="">
                                    <span class="check-type-label">@lang('Public')</span>
                                </label>
                                <label for="category02" class="check-type check-type-warning">
                                    <input class="check-type-input" type="radio" value="1" name="visibility" id="category02">
                                    <span class="check-type-label">@lang('Private')</span>
                                </label>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Create')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <x-search-form placeholder='Title/username' />
@endpush

@push('script')
    <script>
        (function($) {

            "use strict";

            $('.editPlaylist').on('click', function() {
                const modal = $('#playlistModal');
                var data = $(this).data('playlist');

                const url = $(this).data('action');
                modal.find('form').attr('action', url);
                modal.find('[name="title"]').val(data.title);
                modal.find('[name="description"]').val(data.description);
                modal.find('[name="visibility"]').val(data.visibility).trigger('change');
                modal.find('.modal-title').text('@lang('Edit playlist')')
                modal.find('.submitBtn').text('@lang('Update')');
                modal.modal('show');
            });

        })(jQuery);
    </script>
@endpush
