<div class="sidebar-menu">
    <div class="sidebar-menu__inner">
        <!-- Sidebar Logo -->
        <div class="sidebar-logo d-none d-xxl-block">
            <a href="{{ route('home') }}" class="side-sm-logo"><img src="{{ siteFavIcon() }}" alt="@lang('logo')"></a>
            <a href="{{ route('home') }}" class="sidebar-logo__link dark"><img src="{{ siteLogo() }}" alt="@lang('logo')"></a>
            <a href="{{ route('home') }}" class="sidebar-logo__link light"><img src="{{ siteLogo('dark') }}" alt="@lang('logo')"></a>
        </div>

        <ul class="sidebar-menu-list">
            <li class="sidebar-menu-list__item {{ menuActive('home') }}">
                <a href="{{ route('home') }}" class="sidebar-menu-list__link">
                    <span class="icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"
                             fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                             stroke-linejoin="round" class="lucide lucide-house">
                            <path d="M15 21v-8a1 1 0 0 0-1-1h-4a1 1 0 0 0-1 1v8" />
                            <path
                                  d="M3 10a2 2 0 0 1 .709-1.528l7-5.999a2 2 0 0 1 2.582 0l7 5.999A2 2 0 0 1 21 10v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z" />
                        </svg>
                    </span>
                    <span class="text">@lang('Home')</span>
                </a>
            </li>
            <li class="sidebar-menu-list__item">
                <a href="{{ route('shorts.list') }}" class="sidebar-menu-list__link {{ menuActive('shorts.list') }}">
                    <span class="icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 20 20"
                             fill="none">
                            <g id="Shorts">
                                <g id="Group 68">
                                    <path id="Subtract"
                                          d="M4.83441 6.10509L5.08441 6.53811L4.83441 6.10509ZM11.1872 2.43733L10.9372 2.00432L11.1872 2.43733ZM15.6407 3.63066L16.0737 3.38066L15.6407 3.63066ZM14.4474 8.08422L14.1974 7.65121L14.4474 8.08422ZM14.2037 8.22488L13.9537 7.79187C13.7979 7.88186 13.7024 8.04867 13.7038 8.22863C13.7051 8.4086 13.8031 8.57396 13.9603 8.6616L14.2037 8.22488ZM14.2436 13.8949L14.4936 14.3279L14.2436 13.8949ZM7.89089 17.5627L7.64089 17.1297L7.89089 17.5627ZM3.43733 16.3693L3.00432 16.6193L3.43733 16.3693ZM4.63066 11.9158L4.38066 11.4828L4.63066 11.9158ZM4.8743 11.7751L5.1243 12.2081C5.28016 12.1181 5.37564 11.9513 5.37429 11.7714C5.37294 11.5914 5.27497 11.426 5.11778 11.3384L4.8743 11.7751ZM4.58441 5.67208C2.78592 6.71044 2.16971 9.01016 3.20807 10.8087L4.07409 10.3087C3.31188 8.98845 3.76421 7.30032 5.08441 6.53811L4.58441 5.67208ZM10.9372 2.00432L4.58441 5.67208L5.08441 6.53811L11.4372 2.87035L10.9372 2.00432ZM16.0737 3.38066C15.0354 1.58217 12.7356 0.965961 10.9372 2.00432L11.4372 2.87035C12.7574 2.10813 14.4455 2.56046 15.2077 3.88066L16.0737 3.38066ZM14.6974 8.51723C16.4959 7.47887 17.1121 5.17915 16.0737 3.38066L15.2077 3.88066C15.9699 5.20086 15.5176 6.88899 14.1974 7.65121L14.6974 8.51723ZM14.4537 8.6579L14.6974 8.51723L14.1974 7.65121L13.9537 7.79187L14.4537 8.6579ZM15.87 9.19135C15.5184 8.58236 15.0208 8.10794 14.4472 7.78817L13.9603 8.6616C14.3806 8.89595 14.7452 9.24324 15.004 9.69135L15.87 9.19135ZM14.4936 14.3279C16.2921 13.2896 16.9083 10.9898 15.87 9.19135L15.004 9.69135C15.7662 11.0115 15.3138 12.6997 13.9936 13.4619L14.4936 14.3279ZM8.14089 17.9957L14.4936 14.3279L13.9936 13.4619L7.64089 17.1297L8.14089 17.9957ZM3.00432 16.6193C4.04268 18.4178 6.3424 19.034 8.14089 17.9957L7.64089 17.1297C6.32069 17.8919 4.63256 17.4395 3.87035 16.1193L3.00432 16.6193ZM4.38066 11.4828C2.58217 12.5211 1.96596 14.8208 3.00432 16.6193L3.87035 16.1193C3.10813 14.7991 3.56046 13.111 4.88066 12.3488L4.38066 11.4828ZM4.6243 11.3421L4.38066 11.4828L4.88066 12.3488L5.1243 12.2081L4.6243 11.3421ZM3.20807 10.8087C3.55967 11.4176 4.05727 11.8921 4.63083 12.2118L5.11778 11.3384C4.69743 11.104 4.33281 10.7568 4.07409 10.3087L3.20807 10.8087Z"
                                          fill="currentColor" />
                                    <path id="Vector"
                                          d="M8.04688 8.62652C8.04688 8.41646 8.26368 8.28345 8.441 8.38455L11.1694 9.94237C11.2111 9.9662 11.2459 10.0012 11.2701 10.0438C11.2943 10.0863 11.3071 10.1348 11.3071 10.1842C11.3071 10.2336 11.2943 10.2821 11.2701 10.3247C11.2459 10.3672 11.2111 10.4022 11.1694 10.4261L8.441 11.9836C8.40052 12.0067 8.35493 12.0185 8.30874 12.0177C8.26254 12.017 8.21733 12.0038 8.17755 11.9794C8.13777 11.955 8.1048 11.9203 8.08189 11.8786C8.05898 11.837 8.04691 11.7899 8.04688 11.7419V8.62652Z"
                                          stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" />
                                </g>
                            </g>
                        </svg>
                    </span>
                    <span class="text">@lang('Shorts')</span>
                </a>
            </li>
            <li class="sidebar-menu-list__item">
                <a href="{{ route('trending.list') }}"
                   class="sidebar-menu-list__link {{ menuActive('trending.list') }} ">
                    <span class="icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 20 20"
                             fill="none">
                            <path
                                  d="M12.8014 4.345C14.2388 4.98731 15.4122 6.10339 16.1257 7.50679C16.8392 8.91019 17.0496 10.5159 16.7217 12.0558C16.3937 13.5956 15.5473 14.9763 14.3239 15.9672C13.1005 16.958 11.5741 17.4991 9.99971 17.5C8.65305 17.4999 7.33606 17.1044 6.21222 16.3625C5.08839 15.6205 4.20719 14.5649 3.67803 13.3265C3.14886 12.0882 2.99502 10.7217 3.23561 9.39672C3.47621 8.07173 4.10063 6.84658 5.03137 5.87333C5.67276 6.76894 6.51909 7.49813 7.49971 8C7.51688 6.89886 7.77681 5.81506 8.26094 4.82591C8.74508 3.83675 9.4415 2.9666 10.3005 2.2775C10.9562 3.15683 11.8136 3.86563 12.8005 4.34417L12.8014 4.345Z"
                                  stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" />
                            <path
                                  d="M9.16406 9.44856C9.16406 9.23439 9.3851 9.09879 9.56589 9.20187L12.3475 10.7901C12.3901 10.8144 12.4255 10.8501 12.4502 10.8935C12.4749 10.9368 12.4879 10.9863 12.4879 11.0367C12.4879 11.087 12.4749 11.1365 12.4502 11.1799C12.4255 11.2232 12.3901 11.2589 12.3475 11.2832L9.56589 12.8712C9.52461 12.8948 9.47813 12.9067 9.43103 12.906C9.38394 12.9052 9.33784 12.8917 9.29729 12.8669C9.25673 12.842 9.22312 12.8066 9.19976 12.7641C9.1764 12.7217 9.1641 12.6737 9.16406 12.6248V9.44856Z"
                                  stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                    </span>
                    <span class="text">@lang('Trending')</span>
                </a>
            </li>

            <li class="sidebar-menu-list__item">
                <a href="{{ route('stock.video') }}"
                   class="sidebar-menu-list__link {{ menuActive('stock.video') }}">
                    <span class="icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 18 18"
                             fill="none">
                            <g clip-path="url(#clip0_472_13300)">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M14.9384 1.43999C14.9384 1.14176 14.6967 0.899994 14.3984 0.899994C14.1002 0.899994 13.8584 1.14176 13.8584 1.43999V3.05999H12.2384C11.9402 3.05999 11.6984 3.30176 11.6984 3.59999C11.6984 3.89823 11.9402 4.13999 12.2384 4.13999H13.8584V5.75999C13.8584 6.05823 14.1002 6.29999 14.3984 6.29999C14.6967 6.29999 14.9384 6.05823 14.9384 5.75999V4.13999H16.5584C16.8567 4.13999 17.0984 3.89823 17.0984 3.59999C17.0984 3.30176 16.8567 3.05999 16.5584 3.05999H14.9384V1.43999ZM5.71893 3.05999H5.75844H9.71844C10.0167 3.05999 10.2584 3.30176 10.2584 3.59999C10.2584 3.89823 10.0167 4.13999 9.71844 4.13999H5.75844C4.72494 4.13999 4.00414 4.14114 3.46028 4.21426C2.93197 4.28529 2.65219 4.41521 2.45293 4.61448C2.25366 4.81375 2.12373 5.09352 2.05271 5.62184C1.97958 6.16569 1.97844 6.88649 1.97844 7.91999V12.24C1.97844 13.2735 1.97958 13.9943 2.05271 14.5382C2.12373 15.0665 2.25366 15.3462 2.45293 15.5455C2.65219 15.7448 2.93197 15.8747 3.46028 15.9458C4.00414 16.0188 4.72494 16.02 5.75844 16.02H10.0784C11.1119 16.02 11.8327 16.0188 12.3766 15.9458C12.9049 15.8747 13.1847 15.7448 13.384 15.5455C13.5833 15.3462 13.7131 15.0665 13.7842 14.5382C13.8573 13.9943 13.8584 13.2735 13.8584 12.24V8.27999C13.8584 7.98177 14.1002 7.73999 14.3984 7.73999C14.6967 7.73999 14.9384 7.98177 14.9384 8.27999V12.24V12.2795C14.9384 13.2642 14.9384 14.0579 14.8546 14.6821C14.7674 15.3302 14.581 15.8758 14.1477 16.3092C13.7142 16.7426 13.1686 16.929 12.5205 17.0161C11.8963 17.1 11.1026 17.1 10.118 17.1H10.0784H5.75844H5.71893C4.73427 17.1 3.9406 17.1 3.31638 17.0161C2.6683 16.929 2.12263 16.7426 1.68925 16.3092C1.25587 15.8758 1.06947 15.3302 0.982332 14.6821C0.898409 14.0579 0.898423 13.2642 0.898438 12.2795V12.24V7.91999V7.88049C0.898423 6.89582 0.898409 6.10215 0.982332 5.47793C1.06947 4.82985 1.25587 4.28419 1.68925 3.85081C2.12263 3.41742 2.6683 3.23102 3.31638 3.14389C3.9406 3.05997 4.73427 3.05998 5.71893 3.05999ZM8.98109 8.21944L9.01673 8.2432L9.30077 8.43256L9.33396 8.45467C9.71189 8.70659 10.0446 8.92835 10.2777 9.13895C10.5255 9.36287 10.7604 9.66167 10.7604 10.08C10.7604 10.4983 10.5255 10.7971 10.2777 11.021C10.0447 11.2316 9.71189 11.4534 9.33403 11.7053L9.30077 11.7274L9.01673 11.9168L8.98109 11.9405C8.51885 12.2487 8.12184 12.5135 7.79157 12.6695C7.45238 12.8297 7.02645 12.9517 6.6039 12.7256C6.18134 12.4994 6.04664 12.0773 5.99178 11.7062C5.93837 11.345 5.9384 10.8677 5.93844 10.3122V10.2694V9.89063V9.84779C5.9384 9.29224 5.93837 8.81503 5.99178 8.4538C6.04664 8.08264 6.18134 7.66056 6.6039 7.43442C7.02645 7.20827 7.45238 7.33031 7.79157 7.49054C8.12184 7.6465 8.51885 7.91125 8.98109 8.21944ZM7.09449 8.39217C7.09415 8.39167 7.09693 8.3908 7.10378 8.39087C7.09824 8.39267 7.09482 8.3926 7.09449 8.39217ZM7.11621 8.39167C7.14622 8.39512 7.21075 8.4106 7.33041 8.46712C7.57953 8.58477 7.90965 8.80315 8.41769 9.14183L8.70165 9.33112C9.12293 9.61199 9.38702 9.78976 9.55356 9.94024C9.63218 10.0113 9.66422 10.055 9.67653 10.0763L9.67855 10.08L9.67653 10.0837C9.66422 10.105 9.63218 10.1487 9.55356 10.2197C9.38702 10.3702 9.12293 10.548 8.70165 10.8289L8.41769 11.0182C7.90965 11.3568 7.57953 11.5752 7.33041 11.6929C7.21075 11.7494 7.14622 11.7649 7.11621 11.7683C7.1024 11.7415 7.07952 11.6792 7.06017 11.5483C7.01987 11.2757 7.01844 10.8799 7.01844 10.2694V9.89063C7.01844 9.28007 7.01987 8.88429 7.06017 8.6117C7.07952 8.4808 7.1024 8.41852 7.11621 8.39167ZM7.09449 11.7678C7.09482 11.7674 7.09824 11.7673 7.10378 11.7691C7.09693 11.7692 7.09415 11.7683 7.09449 11.7678ZM7.12241 11.7791C7.12697 11.7827 7.12886 11.7856 7.12866 11.7861C7.12845 11.7867 7.12616 11.7849 7.12241 11.7791ZM7.12241 8.38087C7.12616 8.37511 7.12845 8.37331 7.12866 8.37388C7.12886 8.37439 7.12697 8.37727 7.12241 8.38087Z"
                                      fill="currentColor" />
                            </g>
                            <defs>
                                <clipPath id="clip0_472_13300">
                                    <rect width="18" height="18" fill="white" />
                                </clipPath>
                            </defs>
                        </svg>
                    </span>
                    <span class="text">@lang('Stock Video')</span>
                </a>
            </li>

            <span class="separate-border"></span>


            @auth

                <li class="sidebar-menu-list__item">
                    <a href="{{ route('user.history') }}"
                       class="sidebar-menu-list__link {{ menuActive('user.history') }}">
                        <span class="icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"
                                 fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                 stroke-linejoin="round" class="lucide lucide-history">
                                <path d="M3 12a9 9 0 1 0 9-9 9.75 9.75 0 0 0-6.74 2.74L3 8" />
                                <path d="M3 3v5h5" />
                                <path d="M12 7v5l4 2" />
                            </svg>
                        </span>
                        <span class="text">@lang('History')</span>
                    </a>
                </li>
                <li class="sidebar-menu-list__item">
                    <a href="{{ route('user.watch.later.list') }}"
                       class="sidebar-menu-list__link {{ menuActive('user.watch.later.list') }}">
                        <span class="icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20"
                                 fill="none">
                                <path
                                      d="M9.45833 3.19667C9.40417 3.37167 9.375 3.5575 9.375 3.75C9.375 4.095 9.655 4.375 10 4.375H13.75C13.9158 4.375 14.0747 4.30915 14.1919 4.19194C14.3092 4.07473 14.375 3.91576 14.375 3.75C14.3751 3.56243 14.347 3.3759 14.2917 3.19667M9.45833 3.19667C9.57669 2.81392 9.81448 2.47911 10.1369 2.24128C10.4593 2.00345 10.8494 1.87509 11.25 1.875H12.5C13.3433 1.875 14.0558 2.43167 14.2917 3.19667M9.45833 3.19667C9.145 3.21583 8.83333 3.23833 8.52167 3.26333C7.57917 3.34167 6.875 4.14417 6.875 5.09V6.875M14.2917 3.19667C14.605 3.21583 14.9167 3.23833 15.2283 3.26333C16.1708 3.34167 16.875 4.14417 16.875 5.09V13.75C16.875 14.2473 16.6775 14.7242 16.3258 15.0758C15.9742 15.4275 15.4973 15.625 15 15.625H13.125M6.875 6.875H4.0625C3.545 6.875 3.125 7.295 3.125 7.8125V17.1875C3.125 17.705 3.545 18.125 4.0625 18.125H12.1875C12.705 18.125 13.125 17.705 13.125 17.1875V15.625M6.875 6.875H12.1875C12.705 6.875 13.125 7.295 13.125 7.8125V15.625"
                                      stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" />
                                <path
                                      d="M6.66406 11.0682C6.66406 10.8898 6.84826 10.7768 6.99891 10.8627L9.31697 12.1862C9.3524 12.2064 9.38194 12.2362 9.40252 12.2723C9.4231 12.3085 9.43396 12.3497 9.43396 12.3917C9.43396 12.4336 9.4231 12.4749 9.40252 12.511C9.38194 12.5471 9.3524 12.5769 9.31697 12.5971L6.99891 13.9204C6.96452 13.9401 6.92579 13.9501 6.88654 13.9494C6.84729 13.9488 6.80888 13.9376 6.77508 13.9168C6.74129 13.8961 6.71328 13.8666 6.69381 13.8312C6.67434 13.7958 6.66409 13.7558 6.66406 13.7151V11.0682Z"
                                      stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </span>
                        <span class="text">@lang('Watch Later')</span>
                    </a>
                </li>
                <li class="sidebar-menu-list__item">
                    <a href="{{ route('user.playlist.index') }}"
                       class="sidebar-menu-list__link {{ menuActive('playlists.index') }}">
                        <span class="icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                 fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                 stroke-linejoin="round" class="lucide lucide-list-video">
                                <path d="M12 12H3" />
                                <path d="M16 6H3" />
                                <path d="M12 18H3" />
                                <path d="m16 12 5 3-5 3v-6Z" />
                            </svg>
                        </span>
                        <span class="text">@lang('Playlist')</span>
                    </a>
                </li>
                <span class="separate-border"></span>
            @endauth
            @if (auth()->check() && !blank(auth()->user()->subscriptions))
                @php
                    $subscriptions = auth()->user()->subscriptions;
                @endphp
                <li class="sidebar-menu-list__item">
                    <div class="sidebar-menu-list__link sidebar-menu-list__title">
                        <span class="text">@lang('Subscriptions')</span>
                    </div>
                </li>
                @foreach ($subscriptions as $subscription)
                    <li class="sidebar-menu-list__item">
                        <a href="{{ route('preview.channel', $subscription->followUser->slug) }}"
                           class="sidebar-menu-list__link {{ menuActive('stock.video') }}">
                            <span class="author_image">
                                <img class="fit-image"
                                     src="{{ getImage(getFilePath('userProfile') . '/' . $subscription->followUser->image) }}"
                                     alt="">
                            </span>
                            <span class="text">{{ $subscription->followUser->channel_name }}</span>
                        </a>
                    </li>
                @endforeach
                <span class="separate-border"></span>
            @endif
            @php
                $categories = App\Models\Category::active()->withCount('videos')->orderByDesc('videos_count')->take(12)->get();
            @endphp
            @foreach ($categories as $category)
                <li class="sidebar-menu-list__item">
                    <a href="{{ route('category.video', $category->slug) }}"
                       class="sidebar-menu-list__link {{ menuActive('category.video', null, $category->slug) }}">
                        <span class="icon">
                            @php
                                echo $category->icon;
                            @endphp
                        </span>
                        <span class="text">{{ __($category->name) }}</span>
                    </a>
                </li>
            @endforeach
        </ul>
    </div>
</div>
