@extends($activeTemplate . 'layouts.frontend')
@section('content')

    <div class="channel-body">
        <div class="channel-cover">
            <img src="{{ getImage(getFilePath('cover') . '/' . $user->cover_image) }}" alt="Channel Cover Photo">
            <div class="social">

                @if (@$user->social_links?->facebook)
                    <a class="social__link" href="{{ @$user->social_links?->facebook }}" target="__blank"><i
                           class="vti-facebook"></i></a>
                @endif
                @if (@$user->social_links?->twitter)
                    <a class="social__link" href="{{ @$user->social_links?->twitter }}" target="__blank"><i class="vti-twitter"></i></a>
                @endif
                @if (@$user->social_links?->instragram)
                    <a class="social__link" href="{{ @$user->social_links?->instragram }}" target="__blank"><i class="vti-instagram"></i></a>
                @endif
                @if (@$user->social_links?->descord)
                    <a class="social__link" href="{{ @$user->social_links?->descord }}" target="__blank"><i class="vti-descord"></i></a>
                @endif
                @if (@$user->social_links?->descord)
                    <a class="social__link" href="{{ @$user->social_links?->tiktok }}" target="__blank"><i class="vti-tiktok"></i></a>
                @endif
            </div>
        </div>
        <div class="channel-header">
            <div class="channel-header__content">
                <div class="avatar">
                    <img class="fit-image" src="{{ getImage(getFilePath('userProfile') . '/' . $user->image) }}"
                         alt="Channel Profile Picture">
                </div>
                <h3 class="name">{{ $user->channel_name }}</h3>
                <span class="username"><span>@</span>{{ $user->username }}</span>
                <div class="meta">

                    <span> <span class="subscribeCount">{{ formatNumber($subscriberCount ?? 0) }}</span> @lang('subscribers')</span>
                    @if ($user->id == auth()->id())
                        <span>{{ $videosCount ?? 0 }} @lang('videos')</span>
                    @else
                        <span>{{ $user->videos->where('visibility', Status::PUBLIC)->where('status', Status::PUBLISHED)->count() }}
                            @lang('videos')</span>
                    @endif
                </div>
            </div>

            @if (auth()->check() && auth()->id() != $user->id)
                @php
                    $authUser = auth()->user();
                    $subscribed = in_array($authUser->id, $authUser->isSubscribe());
                @endphp
                <div class="channel-header__buttons subscriber-btn">
                    <button
                            class="btn cta @if (!$subscribed) btn--white  subcriberBtn @else  btn--white outline unSubcriberBtn @endif">
                        @if ($subscribed)
                            @lang('Unsubscribe')
                        @else
                            @lang('Subscribe')

                            <span class="shape">
                                <span></span>
                                <span></span>
                                <span></span>
                                <span></span>
                                <span></span>
                                <span></span>
                                <span></span>
                                <span></span>
                            </span>
                        @endif
                    </button>
                </div>
            @endif


        </div>
        <div class="channel-tab">
            <a class="channel-tab__item {{ menuActive('preview.channel') }}"
               href="{{ route('preview.channel', $user->slug) }}">@lang('Videos')</a>
            <a class="channel-tab__item {{ menuActive(['preview.playlist', 'preview.playlist.videos']) }}"
               href="{{ route('preview.playlist', $user->slug) }}">@lang('Playlists')</a>
            <a class="channel-tab__item {{ menuActive('preview.shorts') }} "
               href="{{ route('preview.shorts', $user->slug) }}">@lang('Shorts')</a>
            <a class="channel-tab__item {{ menuActive('preview.about') }}"
               href="{{ route('preview.about', $user->slug) }}">@lang('About')</a>
        </div>
        @include($activeTemplate . 'partials.channel.' . $bladeName)
    </div>

    @if (auth()->check())
        {{-- unSubcriberModal --}}
        <div class="modal scale-style fade custom--modal" id="unSubcriberModal" aria-labelledby="unSubcriberModalLabel"
             aria-hidden="true" tabindex="-1">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">@lang('Confirm Alert!')</h5>
                        <button class="close modal-close-btn" data-bs-dismiss="modal" type="button" aria-label="Close">
                            <i class="las la-times"></i>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>@lang('Are you sure you want to unsubscribe this channel?')</p>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--sm btn--white outline" data-bs-dismiss="modal"
                                type="button">@lang('No')</button>
                        <button class="btn btn--sm btn--white confirmUnsubscribe" type="button">@lang('Yes')</button>
                    </div>
                </div>
            </div>
        </div>
    @endif

@endsection
@if (auth()->check())
    @push('script')
        <script>
            (function($) {
                'use strict';
                $(document).on('click', 'button.cta', function() {
                    $(this).addClass('active');
                    setTimeout(() => {
                        $(this).removeClass('active');
                    }, 300);
                });
                // for subscribe
                $(document).on('click', '.unSubcriberBtn', function() {
                    $('#unSubcriberModal').modal('show');
                });

                $(document).on('click', '.confirmUnsubscribe', function() {
                    subscribers();
                    $('#unSubcriberModal').modal('hide');
                });

                $(document).on('click', '.subcriberBtn', function() {
                    subscribers();
                });

                function subscribers() {

                    $.ajax({
                        type: "post",
                        url: "{{ route('user.subscribe.channel', $user->id) }}",
                        dataType: "json",
                        headers: {
                            'X-CSRF-TOKEN': "{{ csrf_token() }}"
                        },
                        success: function(response) {



                            if (response.remark === 'subscribed') {
                                $('.subscriber-btn').html(`
                  <button class="btn btn--white outline unSubcriberBtn"> @lang('Unsubscribe')</button> `)
                                $('.subscribeCount').text(response.data.subscriber_count)

                            } else if (response.remark === 'unsubscribe') {
                                $('.subscriber-btn').html(`
                 <button class="btn cta btn--white subcriberBtn">@lang('Subscribe')
                                        <span class="shape">
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                    </span></button>
                `)
                                $('.subscribeCount').text(response.data.subscriber_count)
                            } else {

                                notify('error', response.message);
                            }
                        }

                    });
                }

            })(jQuery);
        </script>
    @endpush
@endif
